
/**
 * 监听播放器播放
 */
(function($){
    
    /**
     * 检测h5 video准备状态
     */
    function videoIsReady(player,fn){
        if(player.readyState == 4){
            runFn(fn)
        }else{
            setTimeout(function(){
                videoIsReady(player,fn)
            },100)
        }
    }
    /**
     * 对外暴露方法
     */
    window.playerMonitor = playerMonitor;

    /**
     * 创建播放器监听方法
     * @param {Object}   player  播放器对象
     * @param {Number}   type    102 h5 video视频 0 本地视频  1 乐视云  3 优酷  5 保利威视  6 cc视频  8 腾讯云  9 七牛云  10 阿里云  12 百度云 
     * @param {Function} fns     回调函数列表
     * 已整合：h5 video视频，ck本地视频，保利威视，腾讯云，阿里云，百度云
     */
    
    function playerMonitor(player,type,fns){
        var that = this;
        this.currentTime = 0;
        if(!player){
            return false
        }

        if(player.nodeName === 'VIDEO'){
            type = 102;
        }
        this.type = type;
        this.player = player;
        switch (type) {
            case 102:
                /**
                 * 创建播放开关，避免播放多次监测
                 */
                videoIsReady(player,function(){
                    runFn(fns.ready)
     
                })
                
                player.addEventListener('error',function(){
                    runFn(fns.error)
                });
                player.addEventListener('play',function(){
                    runFn(fns.play)
                    
                });
                player.addEventListener('pause',function(){
                    runFn(fns.pause);
     
                });
                player.addEventListener('seeking',function(){
                    runFn(fns.seek)
                })
                player.addEventListener('ended',function(){
                    runFn(fns.over)
                })
                break
            case 0:
               
                player.addListener('loadedmetadata',function(){
                    runFn(fns.ready)
                });
                
                //出错
                player.addListener('error',function(){
                    runFn(fns.error)
                });

                
                //播放
                player.addListener('play',function(){
                    runFn(fns.play)
                });
                
                //暂停
                player.addListener('pause',function(){
                    runFn(fns.pause)
                });
                

                //调整进度条
                player.addListener('seekTime',function(){
                    runFn(fns.seek)
                });
                window.ckPlayer_seek = function(){
                    
                };
                //播放结束
                player.addListener('ended',function(){
                    runFn(fns.over)
                });
                
                //监听当前时间
                player.addListener('time',function(time){
                    that.currentTime = time;
                });

                break
            case 5:
                //准备
                window.s2j_onPlayerInitOver = function(){
                    runFn(fns.ready)
                };
                //播放
                window.s2j_onPlayStart = function(){
                    runFn(fns.play)
                };
                //暂停
                window.s2j_onVideoPause = function(){
                    runFn(fns.pause)
                };
                //时间跳转
                window.s2j_onVideoSeek = function(){
                    runFn(fns.seek)
                };

                //播放结束
                window.s2j_onPlayOver = function(){
                    runFn(fns.over)
                };
                
                //出错
                window.s2j_onPlayerError = function(){
                    runFn(fns.error)
                }
                break
            case 8:
                console.log(player)
                
                //准备
                player.on('ready',function(){
                    player.seekable(12)
                    runFn(fns.ready)
                });
                //播放
                player.on('play',function(){
                    runFn(fns.play)
                });
                //暂停
                player.on('pause',function(){
                    runFn(fns.pause)
                });
                //时间跳转
                player.on('seeking',function(){
                    runFn(fns.seek)
                });
                //播放结束
                player.on('ended',function(){
                    runFn(fns.over)
                });

                //出错
                player.on('error',function(){
                    runFn(fns.error)
                })

                break
            case 10:
                //准备
                player.on('ready',function(){
                    runFn(fns.ready)
					
                });
                //播放
                player.on('play',function(){
                    runFn(fns.play)
                });
                //暂停
                player.on('pause',function(){
                    runFn(fns.pause)
                });
                //时间跳转
                player.on('completeSeek',function(){
                    runFn(fns.seek)
                });
                //播放结束
                player.on('ended',function(){
                    runFn(fns.over)
                });
                //出错
                player.on('error',function(){
                    runFn(fns.error)
                })
                
                break
            case 12:
                //准备
                player.onReady(function(){
                    runFn(fns.ready)
                });
                //播放
                player.onPlay(function(){
                    runFn(fns.play)
                });
                //暂停
                player.onPause(function(){
                    runFn(fns.pause)
                });
                //时间跳转
                player.onSeek(function(){
                    runFn(fns.seek)
                });
                //播放结束
                player.onComplete(function(){
                    runFn(fns.over)
                });
                //出错
                player.onError(function(){
                    runFn(fns.error)
                })
                break;
            
        }

    }

    /**
     * 获取当前播放时间
     */
    playerMonitor.prototype.getCurrentTime = function(){
        switch (this.type) {
            case 102:
                return this.player.currentTime
                break
            case 0: 
                return this.currentTime
                break
            case 5:
                return this.player.j2s_getCurrentTime()
                break
            case 8:
                return this.player.currentTime()
                break
            case 10:
                return this.player.getCurrentTime()
                break
            case 12:
                return this.player.getPosition()
                break
        }
    }
    /**
     * 获取视频总时长
     */
    playerMonitor.prototype.getDuration = function(){
        
        switch (this.type) {
            case 102:
                return this.player.duration
                break
            case 0:
                return this.player.getMetaDate().duration
                break
            case 5:
                return this.player.j2s_getDuration()
                break
            case 8:
                return this.player.duration()
                break
            case 10:
            case 12:
                return this.player.getDuration()
                break
        }
    }

    /**
     * 播放
     */
    playerMonitor.prototype.play = function(){
        switch (this.type) {
            case 0:
                this.player.videoPlay()
                break
            case 5:
                this.player.j2s_resumeVideo()
                break
            case 8:
            case 10:
            case 12:
            case 102:
                this.player.play()
                break
        }
    }

    /**
     * 暂停
     */
    playerMonitor.prototype.pause = function(){
        switch (this.type) {
            case 0:
                this.player.videoPause()
                break
            case 5:
                this.player.j2s_pauseVideo()
                break
            case 8:
            case 10:
            case 12:
            case 102:
                this.player.pause()
                break

        }
    }

    /**
     * 拖动进度条
     */
    playerMonitor.prototype.seek = function(time){
        switch (this.type) {
            case 0:
                this.player.videoSeek(time)
                break
            case 5:
                this.player.j2s_seekVideo(time)
                break
            case 8:
                console.log(this.player)
                this.player.play(time)
                break
            case 10:
            case 12:
                this.player.seek(time)
                break
        }
    }

    function runFn(fn,info){
        typeof fn === 'function' && fn(info)
    }

})(jQuery);



